/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import java.util.TreeSet;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import noppes.npcs.CustomNpcs;

public class ClientHandler {
    static ClientHandler instance;
    TreeSet<Integer> customDimensions = new TreeSet();

    public static ClientHandler getInstance() {
        if (instance == null) {
            instance = new ClientHandler();
        }
        return instance;
    }

    public void cleanUp() {
        for (int id : this.customDimensions) {
            if (!DimensionManager.isDimensionRegistered((int)id)) continue;
            DimensionManager.unregisterDimension((int)id);
        }
    }

    public boolean has(int dimensionId) {
        if (dimensionId < 100) {
            return false;
        }
        return this.customDimensions.contains(dimensionId);
    }

    public void sync(int[] dimensions) {
        this.cleanUp();
        this.customDimensions.clear();
        for (int id : dimensions) {
            this.customDimensions.add(id);
            if (DimensionManager.isDimensionRegistered((int)id)) continue;
            DimensionManager.registerDimension((int)id, (DimensionType)CustomNpcs.customDimensionType);
        }
    }
}

